<?php
/**
 * GDF Core
 *
 * Handles setting up the GDF theme.
 *
 * @author   AyeCode
 * @category API
 * @package  GDF/Core
 * @since    2.0.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class GDF_Core {

	/**
	 * GDF version.
	 *
	 * @var string
	 */
	public $version = GDF_VERSION;

	/**
	 * Setup class.
	 *
	 * @since 2.0.0
	 */
	public function __construct() {
		global $gdf;
		$gdf = get_option('gdf',array());
		$this->includes();
		add_action( 'init', array($this,'version_check') );
	}

	/**
	 * Check for version change.
	 */
	public function version_check(){
		$db_version = get_option( 'gdf_db_version' );

		/* If there is no old database version, run the install. */
		if ( empty( $old_db_version ) ){
			$this->install();
		}elseif($db_version  < GDF_VERSION ){
			$this->update();
		}

	}

	/**
	 * Install function
	 */
	public function install(){
		/* Add the database version setting. */
		add_option( 'gdf_db_version', GDF_VERSION );
	}

	/**
	 * Update function
	 */
	public function update(){
		/* Update the database version setting. */
		update_option( 'gdf_db_version', GDF_VERSION );
	}

	/**
	 * Include required files.
	 *
	 * @access private
	 * @since 2.0.0
	 * @return void
	 */
	private function includes() {
		global $pagenow, $wp_version;

		// composer autoloader
		require_once( GDF_DIR . '/vendor/autoload.php' );

		require_once( GDF_DIR . '/includes/general-functions.php' );

		require_once( GDF_DIR . '/includes/class-gdf-theme.php' );


		// widgets
		require_once( GDF_DIR . '/includes/widgets/class-gdf-widget-welcome-login.php' );



		if(is_admin()){
			// admin only
			require_once( GDF_DIR . '/includes/admin/class-gdf-admin.php' );
			if(class_exists('ReduxFrameworkPlugin')){
				require_once( GDF_DIR . '/includes/admin/class-gdf-admin-redux.php' );
			}
		}else{
			// frontend only
			require_once( GDF_DIR . '/includes/class-gdf-assets.php' );
		}

	}
	
	

}
new GDF_Core();